<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!-- CSRF Token -->
	<meta name="csrf-token" content="{{ csrf_token() }}">

	<title>Testing | Sign In</title>

	<!-- Font Awesome -->
	<link rel="stylesheet" href="{{ asset('back/plugins/fontawesome-free/css/all.min.css') }}">
	<!-- icheck bootstrap -->
	<link rel="stylesheet" href="{{ asset('back/plugins/icheck-bootstrap/icheck-bootstrap.min.css') }}">
	<!-- Theme style -->
	<link rel="stylesheet" href="{{ asset('back/dist/css/adminlte.css') }}">
	<style>
		.login-page,
		.register-page {
		  -webkit-align-items: center;
		  -ms-flex-align: center;
		  align-items: center;
		  /*background-color: #e9ecef;*/
		  background: #000;
		  display: -webkit-flex;
		  display: -ms-flexbox;
		  display: flex;
		  -webkit-flex-direction: column;
		  -ms-flex-direction: column;
		  flex-direction: column;
		  height: 100vh;
		  -webkit-justify-content: center;
		  -ms-flex-pack: center;
		  justify-content: center;
		}
		#particles-js {
			width: 100%;

			height: 100vh;
		}
	</style>
</head>
<body class="hold-transition login-page">
	<div id="particles-js">
		
	</div>
	<div class="login-box">
		<!-- /.login-logo -->
		<img src="{{ asset('img/motc.png') }}" class="img-fluid mb-3 mx-auto d-block" style="width: 150px; height: 150px; margin-top: -100px;">
		<div class="card card-outline card-primary">
			<div class="card-header text-center">
				<a href="{{url('/')}}" class="h1"><b>NCSC</b></a>
			</div>
			<div class="card-body">
				<p class="login-box-msg">Sign in to start your session</p>

				<form method="POST" action="{{ route('login') }}">
					@csrf
					<div class="input-group mb-3">
						<input type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus placeholder="Email">
						@error('email')
						<span class="invalid-feedback" role="alert">
							<strong>{{ $message }}</strong>
						</span>
						@enderror
						<div class="input-group-append">
							<div class="input-group-text">
								<span class="fas fa-envelope"></span>
							</div>
						</div>
					</div>
					<div class="input-group mb-3">
						<input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="current-password" placeholder="Password">

						@error('password')
						<span class="invalid-feedback" role="alert">
							<strong>{{ $message }}</strong>
						</span>
						@enderror
						<div class="input-group-append">
							<div class="input-group-text">
								<span class="fas fa-lock"></span>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-8 mt-2">
            <!-- <div class="icheck-primary">
              <input type="checkbox" id="remember">
              <label for="remember">
                Remember Me
              </label>
          </div> -->
          <a href="{{route('register')}}" class="text-center">Register a new membership</a>
      </div>
      <!-- /.col -->
      <div class="col-4">
      	<button type="submit" class="btn btn-primary btn-block">Sign In</button>
      </div>
      <!-- /.col -->
  </div>
</form>

      <!-- <div class="social-auth-links text-center mt-2 mb-3">
        <a href="#" class="btn btn-block btn-primary">
          <i class="fab fa-facebook mr-2"></i> Sign in using Facebook
        </a>
        <a href="#" class="btn btn-block btn-danger">
          <i class="fab fa-google-plus mr-2"></i> Sign in using Google+
        </a>
    </div> -->
    <!-- /.social-auth-links -->

      <!-- <p class="mb-1">
        <a href="forgot-password.html">I forgot my password</a>
    </p> -->
    <p class="mb-0">

    </p>
</div>
<!-- /.card-body -->
</div>
<!-- /.card -->
</div>
<!-- /.login-box -->

<!-- jQuery -->
<script src="{{ asset('back/plugins/jquery/jquery.min.js') }}"></script>
<!-- Bootstrap 4 -->
<script src="{{ asset('back/plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
<!-- AdminLTE App -->
<script src="{{ asset('back/dist/js/adminlte.min.js') }}"></script>
<script src="{{ asset('back/dist/js/particles.min.js') }}"></script>
<script type="text/javascript">
	particlesJS.load('particles-js',
		'particles.json', function(){
		console.log('particles.json loaded ...');
		});
</script>
</body>
</html>
